/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.system;

import de.willuhn.io.IOUtil;
import de.willuhn.logging.Logger;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;

public class StartupParams {
    public static final int MODE_STANDALONE = 0;
    public static final int MODE_SERVER = 1;
    public static final int MODE_CLIENT = 2;
    private Options options = null;
    private String workDir = null;
    private String username = null;
    private String password = null;
    private String passwordCommand = null;
    private int mode = 0;
    private boolean noninteractive = false;
    private boolean ignoreLockfile = false;
    private String[] params = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StartupParams(String[] args) {
        this.params = args;
        Option server = new Option("d", "server", false, "Startet die Anwendung im Server-Mode ohne Benutzeroberfl\u00e4che.");
        Option client = new Option("c", "client", false, "Startet die Anwendung im Client-Mode mit Benutzeroberfl\u00e4che");
        Option standalone = new Option("s", "standalone", false, "Startet die Anwendung im Standalone-Mode mit Benutzeroberfl\u00e4che (Default)");
        OptionGroup mode = new OptionGroup();
        mode.setRequired(false);
        mode.addOption(server);
        mode.addOption(client);
        mode.addOption(standalone);
        this.options = new Options();
        this.options.addOptionGroup(mode);
        this.options.addOption("h", "help", false, "Gibt diesen Hilfe-Text aus");
        this.options.addOption("f", "file", true, "Optionale Angabe des Benutzer-Verzeichnisses (Workdir)");
        this.options.addOption("u", "username", true, "Optionale Angabe des Benutzernamens");
        this.options.addOption("p", "password", true, "Optionale Angabe des Master-Passworts");
        this.options.addOption("w", "passwordfile", true, "Optionale Angabe des Master-Passworts, welches sich in der angegebenen Datei befindet");
        this.options.addOption("P", "passwordcommand", true, "Optional Angabe eines Befehls, der das Master-Passwort auf Stdout ausgibt");
        this.options.addOption("o", "force-password", false, "Angabe des Master-Passworts via Kommandozeile ignorieren (f\u00fcr MacOS n\u00f6tig)");
        this.options.addOption("n", "noninteractive", false, "Koppelt Jameica im Server-Mode von der Konsole ab. Es findet keine Benutzer-Interaktion mehr statt. Die Option wird nur ausgewertet, wenn Jameica im Server-Mode l\u00e4uft.");
        this.options.addOption("l", "ignore-lock", false, "Ignoriert eine ggf. vorhandene Lock-Datei");
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine line = parser.parse(this.options, args);
            if (line.hasOption("h")) {
                this.printHelp();
            }
            if (line.hasOption("d")) {
                Logger.info((String)"starting in SERVER mode");
                this.mode = 1;
            } else if (line.hasOption("c")) {
                Logger.info((String)"starting in CLIENT mode");
                this.mode = 2;
            } else {
                Logger.info((String)"starting in STANDALONE mode");
            }
            if (this.mode == 1 && line.hasOption("n")) {
                Logger.info((String)"activating noninteractive mode");
                this.noninteractive = true;
            }
            if (line.hasOption("l")) {
                Logger.info((String)"ignoring lock file");
                this.ignoreLockfile = true;
            }
            if (line.hasOption("f")) {
                this.workDir = line.getOptionValue("f");
            }
            Logger.info((String)("workdir: " + this.workDir));
            if (line.hasOption("p") && !line.hasOption("o")) {
                this.password = line.getOptionValue("p");
                Logger.info((String)"master password given via commandline");
            }
            if (line.hasOption("u")) {
                this.username = line.getOptionValue("u");
                Logger.info((String)"username given via commandline");
            }
            if (line.hasOption("w")) {
                String file = line.getOptionValue("w");
                File f = new File(file);
                if (!(f.exists() && f.canRead() && f.isFile())) {
                    Logger.warn((String)("option \"w\" given, but file " + file + " not readable, ignoring"));
                } else {
                    BufferedReader r = null;
                    try {
                        r = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
                        this.password = r.readLine();
                        Logger.info((String)("master password given via file " + file));
                    }
                    catch (Throwable throwable) {
                        IOUtil.close((Closeable[])new Closeable[]{r});
                        throw throwable;
                    }
                    IOUtil.close((Closeable[])new Closeable[]{r});
                }
            }
            if (!line.hasOption("P")) return;
            if (line.hasOption("p")) {
                throw new RuntimeException("cannot use option -p (--password) together with -P (--passwordcommand)");
            }
            if (line.hasOption("w")) {
                throw new RuntimeException("cannot use option -w (--passwordfile) together with -P (--passwordcommand)");
            }
            this.passwordCommand = line.getOptionValue("P");
            return;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            this.printHelp();
        }
    }

    private void printHelp() {
        new HelpFormatter().printHelp("jameica.sh|jameica-*.exe|jameica-*.sh <Optionen>", "\nOptionen", this.options, "");
        System.exit(1);
    }

    public String getPassword() {
        return this.password;
    }

    public String getPasswordUsingCommand() {
        String password;
        Process proc;
        if (this.passwordCommand == null) {
            return null;
        }
        try {
            proc = Runtime.getRuntime().exec(this.passwordCommand);
        }
        catch (IOException e) {
            Logger.error((String)("cannot execute password command `" + this.passwordCommand + "`"), (Throwable)e);
            return null;
        }
        try (Scanner scanner = new Scanner(proc.getInputStream(), StandardCharsets.UTF_8);){
            password = scanner.useDelimiter("\\A").next().trim();
        }
        try {
            if (proc.waitFor() != 0) {
                Logger.error((String)("password command `" + this.passwordCommand + "` exited with non-zero exit code: " + proc.exitValue()));
                return null;
            }
        }
        catch (InterruptedException e) {
            Logger.error((String)"password command interrupted", (Throwable)e);
            return null;
        }
        if (password.isEmpty()) {
            Logger.error((String)("password command `" + this.passwordCommand + "` returned empty password"));
            return null;
        }
        return password;
    }

    public String getUsername() {
        return this.username;
    }

    public int getMode() {
        return this.mode;
    }

    public String getWorkDir() {
        return this.workDir;
    }

    public boolean isNonInteractiveMode() {
        return this.noninteractive;
    }

    public boolean isIgnoreLockfile() {
        return this.ignoreLockfile;
    }

    public String[] getParams() {
        return this.params;
    }
}

